<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Group extends Model
{
    use HasFactory;
    protected $fillable=[
        'name',
        'grade_id',
        'user_id',
        'center_id',
        'subject_id',
        'year_id',
        'role',
    ];

    public function users(){
        return $this->belongsToMany(User::class, 'group_user','group_id','user_id')->withPivot('active');;
    }
     public function lessons(){
        return $this->belongsTo(Lesson::class);
    }
      public function ads(){
        return $this->belongsToMany(Advertisement::class,'advertisement_group');
    }
}
