<?php

namespace App\Http\Requests;

use App\Http\Helpers\Helper;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;

class QuizezRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'class_id'=>'required | string',
            'group_id'=>'required | string',
            'subject_id'=>'required | string',
            'from'=>'required | string',
            'to'=>'required | string',
        ];
    }
    public function failedValidation(Validator $validator){
        Helper::sendError('validation error',$validator->errors());
    }
}
