<?php

namespace App\Http\Requests;

use App\Http\Helpers\Helper;
use Illuminate\Contracts\Validation\Validator;
use Illuminate\Foundation\Http\FormRequest;

class AdvertisementsRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return true;
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array|string>
     */
    public function rules(): array
    {
        return [
            'name'=>'required',
            
            'user_id'=>'required',
             'groups'=>'required',
            
            'status'=>'required',
            'start_date'=>'required',
            'end_date'=>'required',
        ];

    }
    public function failedValidation(Validator $validator){
        Helper::sendError( 'validation error' ,$validator->errors());
    }
}
