<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Coupon;
use App\Models\Video;
use Illuminate\Http\Request;
use App\Models\Video_coupon;


class videosController extends Controller
{

     public function index(Request $request){

        $request->validate([
            'teacher_id' => 'required',
        ]);
        $videos= Video::where('teacher_id',$request->teacher_id)->get();

        return response()->json([
            'status'=>200,
            'data'=>  ['videos'=>$videos],
        ],200);

    }

    public function store(Request $request){

        $request->validate([
            'name' => 'required',
            'url' => 'required',
            'duration' => 'required',
            'teacher_id' => 'required',
        ]);
        $video= Video::create([
             'name' => $request->name,
            'url' => $request->url,
            'duration' => $request->duration,
            'teacher_id' => $request->teacher_id,
            'unlock_code' => $request->unlock_code,
            'free' => $request->free,
            ]);

        return response()->json([
            'status'=>200,
            'data'=>  $video ?? 'No videos found',
        ],200);

    }


        public function delete(Request $request){
        $Exam=Video::find($request->id);
        $Exam->delete();
        if($Exam){
            return response()->json([
                'status'=>200,
                'message'=>'Video Deleted Successfully'
            ],200);
        }
    }


     public function generateCode(Request $request){
           $request->validate([
            'number' => 'required|integer',
            'video_id'=>'required|integer',
        ]);
         $codes=[];
        for($i=0;$i < $request->number;$i++){
            $code=substr(md5(mt_rand()), 0, 6);

            $codes[]=Coupon::create([
                'code'=>$code,
                'video_id'=>$request->video_id
            ]);
        }

            return response()->json([
                'status'=>200,
                'message'=>'Codes Generated Successfully',
                'data'=>['codes'=>$codes]
            ],200);

    }
     public function validateCode(Request $request){
          $request->validate([
            'code' => 'required|max:6|min:6',
            'video_id' => 'required',
        ]);
        $code = Coupon::where('code',$request->code)->where('video_id',$request->video_id)->first();
        if($code){
            $user= auth()->user();
            $video_coupon=Video_coupon::create([
                    'video_id'=>$request->video_id,
                    'student_id'=>$user->id,
                ]);

            $code->delete();
              return response()->json([
                'status'=>200,
                'message'=>'تم الإشتراك في الفيديو بنجاح يمكنك مشاهدته لمرتين',

            ],200);
        }else{
             return response()->json([
                'status'=>405,
                'message'=>'من فضلك قم بإدخال كود صحيح',

            ],200);

        }

    }
    public function VideoCodes(Request $request){
        $request->validate([
            'video_id' => 'required',
        ]);
        $video_coupons=Coupon::where('video_id',$request->video_id)->get();
        return response()->json([
            'status'=>200,
            'data'=>['codes'=>$video_coupons]

        ],200);

    }
    
    public function UserVideos(Request $request){
        $user= auth()->user();
        $video_coupons=Video_coupon::where('student_id',$user->id)->with('video')->get();
        return response()->json([
            'status'=>200,
            'data'=>['videos'=>$video_coupons]

        ],200);

    }
    
    
        public function VidoeViews(Request $request){
         $user=auth()->user();
        $request->validate([
            'video_id' => 'required',
        ]);
        $video_coupons=Video_coupon::where('video_id',$request->video_id)->where('student_id',$user->id)->first();
                $video_coupons->times ++;

        if($video_coupons->times <= 2 ){
            $video_coupons->save();
        }else{
            $video_coupons->delete();
        }
        return response()->json([
            'status'=>200,
            'data'=>['views'=>$video_coupons->times]

        ],200);

    }

}
