<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\QuizezRequest;
use App\Http\Resources\QuizezResource;
use App\Models\Quize;
use Illuminate\Http\Request;

class quizezController extends Controller
{
    public function index(){
        $Quize=Quize::all();
        if($Quize->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Quize
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(QuizezRequest $request){

        $Quize=Quize::create([
            'class_id'=>$request->class_id,
            'group_id'=>$request->group_id,
            'subject_id'=>$request->subject_id,
            'from'=>$request->from,
            'to'=>$request->to,

          ]);
        return response()->json([
            'status'=>200,
            'data'=>$Quize,
            'message'=>'Quiz Created Successfully'

        ],200);

    }
    public function show($id){
        $Quize=Quize::findOrFail($id);
        if($Quize){
            return response()->json([
                'status'=>200,
                'group'=>$Quize
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(QuizezRequest $request,$id){
        $Quize = Quize::find($id);
        $Quize->update($request->all());
        return response()->json([
            'status'=>200,
            'data'=>$Quize,
            'message'=>'Quiz Updated Successfully'

        ],200);
    }
    public function delete($id){
        $Quize=Quize::find($id);
        $Quize->delete();
        if($Quize){
            return response()->json([
                'status'=>200,
                'message'=>'Quiz Deleted Successfully'
            ],200);
        }
    }
    public function search($name){
        $Quize=Quize::where('class_id','Like','%'.$name.'%')->get();
        if($Quize->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Quize
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
}
