<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\SubjectRequest;
use App\Http\Resources\SubjectResource;
use App\Models\Subject;
use App\Models\User;
use Illuminate\Http\Request;

class SubjectController extends Controller
{
    public function index (){
        $subject=Subject::all();
        if($subject->count() > 0){
            return response()->json([
                'status'=>200,
                'subject'=>$subject
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function store(SubjectRequest $request){

        $Subject=Subject::create([
            'name'=>$request->name,
            'grade_id'=>$request->grade_id,
            'year_id'=>$request->year_id,
        ]);

        return response()->json([
            'status'=>200,
            'subject'=>$Subject,
            'message'=>'Subject Created Successfully'
        ],200);
    }
    public function show($id){
        $Subject=Subject::findOrFail($id);
        if($Subject){
            return response()->json([
                'status'=>200,
                'group'=>$Subject
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }
    public function update(SubjectRequest $request,$id){
        $Subject = Subject::find($id);
        $Subject->update($request->all());
        return response()->json([
            'status'=>200,
            'subject'=>$Subject,
            'message'=>'Subject Updated Successfully'

        ],200);
    }
    public function delete($id){
        $Subject=Subject::find($id);
        $Subject->delete();
        if($Subject){
            return response()->json([
                'status'=>200,
                'message'=>'Subject Deleted Successfully'
            ],200);
        }
    }
    public function search($name){
        $Subject=Subject::where('name','Like','%'.$name.'%')->get();
        if($Subject->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Subject
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'not found'
            ],404);
        }
    }

    public function subject_users(Request $request){
        $request->validate([
           'id' => 'required',
           'center_id' => 'required',
        ]);

        $center_id = $request->center_id;
        $usersnew = User::with(["centers" => function($q) use($center_id){
            $q->where('users.id', '=', $center_id);
        }])->where('subject_id', $request->id)->get();

        foreach($usersnew as $user){
            $centers = $user->centers;
            if($centers->count() > 0){
                $users[] = $user;

            }
        }
        return response()->json([
            'status'=>200,
            'data' => $users ?? [],
        ],200);

    }

    public function store_subject_users(Request $request){

        $user = User::where('id', $request->teacher_id)->first();
        $subject = Subject::where('id', $request->subject_id)->first();

        if (isset($user) && isset($subject)){
            $user->update([
                'subject_id' =>  $subject->id
            ]);
        }

        return response()->json([
            'status'=>200,
            'data' => isset($user) && isset($subject) ? 'Subject added successfully' : 'No subject or user found',
        ],200);

    }

}
