<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Molakhsat;

class MolakhsatController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        //
       $priefs= Molakhsat::orderBy('id','DESC')->where('grade_id',$request->grade_id)->with('user')->get();
       
                   return response()->json([
                'status'=>200,
                 'data'=>[
                'priefs' => $priefs,
                ] ,
            ],200);
    }
    
     public function teacherPriefs(Request $request)
    {
        //
        $user = auth()->user();
       $priefs= Molakhsat::orderBy('id','DESC')->where('teacher_id',$user->id)->with('user')->get();
                   return response()->json([
                'status'=>200,
                 'data'=>[
                'priefs' => $priefs,
                ] ,
            ],200);
    }
         public function studentPriefs(Request $request)
    {
        //
        $user = auth()->user();
       $priefs= Molakhsat::orderBy('id','DESC')->where('user_id',$user->id)->get();
                   return response()->json([
                'status'=>200,
                 'data'=>[
                'priefs' => $priefs,
                ] ,
            ],200);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        //
        $user =auth()->user();
            $names = [];
            foreach($request->file('images') as $image)
            {
                $destinationPath = 'content_images/';
                $filename = $image->getClientOriginalName();
                $image->move($destinationPath, $filename);
                array_push($names, $filename);          
        
            }
            $images = json_encode($names);
            $priefs=Molakhsat::create([
                'name'=>$request->name,
                'images'=>$images,
                'user_id'=>$user->id,
                'teacher_id'=>$request->teacher_id,
                'grade_id'=>$request->grade_id,
                'decription'=>$request->decription,
                'subject_id'=>$request->subject_id,
                'class'=>$request->class,

                
                ]);
                 return response()->json([
                'status'=>200,
                 'data'=>[
                'priefs' => $priefs,
                ] ,
            ],200);
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(Request $request)
    {
        //
            $prief= Molakhsat::find($request->id);
                $prief->delete();
             return response()->json([
                'status'=>200,
                 'data'=>[] ,
                'message' => "تم حذف الملخص بنجاح",
            ],200);
    }
    
     public function activate(Request $request)
    {
        //ss
                $prief= Molakhsat::find($request->id);
                $prief->state = 1;
                $prief->save();
               return response()->json([
                'status'=>200,
                 'data'=>[
                'priefs' => $prief,
                ] ,
            ],200);
    }
     public function deactivate(Request $request)
    {
        //ss
                $prief= Molakhsat::find($request->id);
                $prief->state = 2;
                $prief->refuse_reason = $request->refuse_reason;
                $prief->save();
               return response()->json([
                'status'=>200,
                 'data'=>[
                'priefs' => $prief,
                ] ,
            ],200);
    }
}
