<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\LessonsRequest;
use App\Http\Resources\LessonsResource;
use App\Models\Lesson;
use App\Models\Lessons_attendance;
use App\Models\User;
use Illuminate\Http\Request;
use Carbon\Carbon;


class LessonsController extends Controller
{
    public function index()
    {
        $lessons = Lesson::orderBy('id',"DESC");

        return response()->json([
            'status' => $lessons->count() > 0 ? 200 : 404,
            'data' => $lessons->count() > 0 ? $lessons : 'No lessons found'
        ], 200);

    }

    public function group_lessons(Request $request)
    {
        $lessons = Lesson::where('group_id', $request->group_id)->orderBy('id', "DESC")->get();

        return response()->json([
            'status' => 200,
            'data' => ['lessons' => $lessons]
        ], 200);

    }


    public function store(LessonsRequest $request)
    {

        $lesson = Lesson::create($request->all());

        return response()->json([
            'status' => 200,
            'data' => $lesson,
            'message' => 'تم انشاء الدرس بنجاح  '
        ], 200);
    }

    public function show($id)
    {
        $lesson = Lesson::findOrFail($id);

        return response()->json([
            'status' => $lesson ? 200 : 404,
            'data' => $lesson ?? 'لا يوجد دروس  '
        ], 200);

    }

    public function update(LessonsRequest $request)
    {
        $lesson = Lesson::find($request->id);

        $lesson->update($request->all());
        return response()->json([
            'status' => 200,
            'data' => $lesson,
            'message' => 'تم تحديث الدرس بنجاح  '
        ], 200);
    }

    public function destroy(Request $request)
    {

        $lesson = Lesson::where('id', $request->id)->delete();

        return response()->json([
            'status' => $lesson ? 200 : 404,
            'message' => $lesson ? 'تم مسح الدرس بنجاح  ' : 'لا يوجد درس  '
        ], 200);

    }

    public function attendance_num(Request $request)
    {

        $user = User::where('code', $request->user_code)->first();
        $lesson = Lesson::where('id', $request->lesson_id)->first();

        if (isset($user) && isset($lesson)) {
            $attendance = Lessons_attendance::create([
                'lesson_id' => $lesson->id,
                'user_id' => $user->id
            ]);
        }

        return response()->json([
            'status' => 200,
            'message' => isset($attendance) ? 'تم تحضير الطالب بنجاح  ' : 'لا يوجد درس'
        ], 200);

    }

    
    

    public function bulk_attendance(Request $request)
    {
        foreach ($request->attendance as $attend) {

            // if($attend->compensation == 1 ){
            //     echo 'lolo';
            // }else{
                $attendance[] = Lessons_attendance::create([
                    'lesson_id' => $attend['lesson_id'],
                    'user_id' => User::where("code", $attend['student_code'])->first()->id
                ]);
            // }
        }

        return response()->json([
            'status' => 200,
            'message' => isset($attendance) ? 'تم تحضير الطلاب بنجاح  ' : 'لا يوجد درس    '
        ], 200);

    }

    public function attendance_qr($id)
    {

        $user = auth()->user();
        $lesson = Lesson::where('id', $id)->first();

        if (isset($user) && isset($lesson)) {
            $attendance = Lessons_attendance::create([
                'lesson_id' => $lesson->id,
                'user_id' => $user->id
            ]);
        }

        return response()->json([
            'status' => 200,
            'message' => isset($attendance) ? 'تم تحضير الطلاب بنجاح  ' : 'لا يوجد درس    '
        ], 200);

    }

    public function lesson_by_date(Request $request)
    {
         $lesson = Lesson::where('group_id', $request->group_id)->where('end_date',null)->orderBy('id','DESC')->first();

        return response()->json([
            'status' => 200 ,
            'data' => $lesson
        ], 200);
    }

    public function get_attendance(Request $request)
    {

        $user = User::where('code', $request->user_code)->first();
        $lesson = Lesson::where('id', $request->lesson_id)->first();

        if (isset($user) && isset($lesson)) {
            $attendance = Lessons_attendance::create([
                'lesson_id' => $lesson->id,
                'user_id' => $user->id
            ]);
        }

        return response()->json([
            'status' => 200,
            'message' => isset($attendance) ? 'User attended successfully' : 'No lessons or users found'
        ], 200);

    }

    public function group_attendance(Request $request)
    {
        $att = 0;
        $user = auth()->user();
        $lessons = Lesson::where('group_id', $request->group_id)->get();
        foreach ($lessons as $lesson) {
            $attendance = Lessons_attendance::where('lesson_id', $lesson->id)->where('user_id', $user->id)->first();
            if ($attendance) {
                $att++;
            }
        }

        return response()->json([
            'status' => 200,
            'data' => ['lessons' => count($lessons), 'attendance' => $att]
        ], 200);
    }
    
    
     public function last_group_attendance(Request $request)
    {
        // $user = auth()->user();
        $lesson = Lesson::where('group_id', $request->group_id)->orderBy('id','DESC')->where('end_date','!=',null)->first();
        $attendance = [];
        if($lesson){
             $attendance = Lessons_attendance::where('lesson_id', $lesson->id)->with('user')->get();
        }
          
        

        return response()->json([
            'status' => 200,
            'data' => ['attendance' => $attendance]
        ], 200);
    }

    public function endLesson(Request $request)
    {
        $lesson=Lesson::find($request->lesson_id);
        $lesson->end_date=$request->end_date;
        $lesson->save();
        return response()->json([
            'status' => 200,
            'message' => isset($lesson) ? 'تم انهاء الدرس بنجاح' : 'لا يوجد درس'
        ], 200);
    }


}
