<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Requests\ExamRequest;
use App\Http\Resources\ExamResource;
use App\Models\Exam;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use App\Models\Student_q_answer;
use App\Models\Exam_results;
use App\Models\Group;
use App\Models\Question;
use App\Models\Answer;
class ExamController extends Controller
{
    public function index(request $request){
         $request->validate([
            'group_id' => 'required',
        ]);
     
        $Exams=Exam::where('group_id',$request->group_id)->orderBy('id','DESC')->get();

            return response()->json([
                'status'=>200,
                'data'=>['exams'=>$Exams]
            ],200);

    }
    

      public function group_exam_resutls(request $request){
                 $request->validate([
            'group_id' => 'required',
        ]);
        $res=[];
        $total=0;
        // $group = Group::where('id', $request->group_id)->with('users')->first();
        // $Exam=Exam::find($request->exam_id);
        
         $group_id = $request->group_id;
        $users = User::whereHas('groups',function($q) use ($group_id){
            $q->where('group_id','=', $group_id);
        })->get();
           foreach($users as $user ){
            $result = Exam_results::where('student_id',$user->id)->where('exam_id',$request->exam_id)->first();
            if($result){
                $res[] =['student'=>$user,'result'=>$result->result,'attendance'=>1] ;
                $total=$result->finnal_degree;
            }else{
                $res[] =['student'=>$user,'result'=>0,'attendance'=>0] ;
            }
            

        }

            return response()->json([
                
                'status'=>200,
                'data'=>['exams'=>$res,'total'=>$total]
            ],200);

    }
    public function store(ExamRequest $request){
        if($request->homework){
            $homework = $request->homework;
            }else{
               $homework = 0;
        }
        $Exam=Exam::create([
            'name'=> $request->name,
            'date_start'=>$request->date_start,
            'end_date'=>$request->end_date,
            'user_id'=>$request->user_id,
            'group_id'=>$request->group_id,
            'status'=>$request->status,
            'homework'=>$homework,
            
          ]);
        return response()->json([
            'status'=>200,
            'data'=>$Exam,
            'message'=>'تم إنشاء الامتحان بنجاح  '
        ],200);
    }
    
    
    public function dublicate(Request $request){
        $Exam=Exam::find($request->exam_id);
        $Exam2=Exam::create([
            'name'=> $Exam->name,
            'date_start'=>$request->date_start,
            'end_date'=>$request->end_date,
            'user_id'=>$Exam->user_id,
            'group_id'=>$request->group_id,
            'status'=>$Exam->status,
            'homework'=>$Exam->homework,
          ]);
          $qs=[];
          $questions = Question::where('exam_id',$request->exam_id)->with('answers')->get();
          foreach($questions as $question){
          $q=Question::create([
            'name'=> $question->name,
            'exam_id'=>$Exam2->id,
            'grades'=>$question->grades,
           
          ]);
              foreach($question->answers as $answer){
               $q->answers[]= Answer::create([
                       "name"=> $answer->name,
                       "question_id"=> $q->id,
                       "right_answer"=> $answer->right_answer,
                       ]);
              }
              
           $qs[] =$q;  
          }
           $Exam2->questions = $qs;
           
         
			
        return response()->json([
            'status'=>200,
            'data'=>['exam'=>$Exam2],
            'message'=>'تم تكرار الامتحان بنجاح  '
        ],200);
    }
    public function show($id){
        $Exam=Exam::findOrFail($id);
        if($Exam){
            return response()->json([
                'status'=>200,
                'group'=>$Exam
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'غير موجود'
            ],404);
        }
    }
    public function update(ExamRequest $request,$id){
        $Exam = Exam::find($id);
        $Exam->update($request->all());
        return response()->json([
            'status'=>200,
            'data'=>$Exam,
            'message'=>'تم تحديث الامتحان بنجاح  '
        ],200);
    }
    public function delete(Request $request){

        $Exam=Exam::find($request->id);

       $Exam->delete();
        if($Exam){
            return response()->json([
                'status'=>200,
                'exam'=>$Exam,
                'message'=>'تم حذف الامتحان بنجاح  '
            ],200);
        }
    }
    public function search($name){
        $Exam=Exam::where('season','Like','%'.$name.'%')->get();
        if($Exam->count() > 0){
            return response()->json([
                'status'=>200,
                'group'=>$Exam
            ],200);
        }else{
            return response()->json([
                'status'=>404,
                'message'=>'غير موجود '
            ],404);
        }
    }
    public function store_student_answer(request $request){

         $request->validate([
            'student_id' => 'required',
            'questions' => 'required',
            'exam_id' => 'required',
        ]);
        // $test= [["question_id"=>1,"answer_id"=>1,"right_answer"=>0]];
        $result = 0;
        $finnal_degree= 0;
        foreach($request->questions as $question){
        $student_answers=Student_q_answer::create([
                'student_id' =>  $request->student_id,
                'exam_id' =>  $request->exam_id,
                'question_id' =>  $question['question_id'],
                'answer_id' =>  $question['answer_id'],
                'right_answer' =>  $question['right_answer'],

            ]);
            if($question['right_answer'] == 1){
               $result +=  $question['grades'];
            }
            $finnal_degree += $question['grades'];

        }
        $exam_results= Exam_results::create([
              'exam_id'=>$request->exam_id,
        'student_id'=> $request->student_id,
             'result'=>$result,
            'finnal_degree'=>$finnal_degree,
            ]);

          return response()->json([
                'status'=>200,
                'data'=>['student_answers' => $student_answers,
                    'exam_results'=>$exam_results
                ]
            ],200);

    }
    
     public function store_student_answer_manual(request $request){

         $request->validate([
            'students_results' => 'required',
            'exam_id' => 'required',
        ]);
        // $test= [["question_id"=>1,"answer_id"=>1,"right_answer"=>0]];
        $exam_results=[];   
          foreach($request->students_results as $result){
        $exam_results[]= Exam_results::create([
              'exam_id'=>$request->exam_id,
             'student_id'=> $result->student_id,
             'result'=>$result->result,
            'finnal_degree'=>$result->finnal_degree,
            ]);

          return response()->json([
                'status'=>200,
                'data'=>[
                    'exam_results'=>$exam_results
                ]
            ],200);
          }

    }
     public function student_answer(request $request){
          $request->validate([
            'student_id' => 'required',

        ]);

        $exam_results= Exam_results::where('student_id' , $request->student_id)->get();
        $student_answers=Student_q_answer::where('student_id' , $request->student_id)->get();

          return response()->json([
                'status'=>200,
                'data'=>[
                    'exam_results'=>$exam_results,
                    'student_answers'=>$student_answers
                ]
            ],200);

    }
     public function exam_questions(request $request){
          $request->validate([
            'exams' => 'required',

        ]);
        $exams=[];
        foreach($request->exams as $exam_id){
            $ex=Exam::where('id',$exam_id)->first();
            $ex->questions=Question::where('exam_id',$exam_id)->with('answers')->get();
            $exams[]=$ex;
        }
      
          return response()->json([
                'status'=>200,
                'data'=>[
                    'exams'=>$exams
                ]
            ],200);

    }
    
     public function groups_exams(request $request){
        $request->validate([
        'groups' => 'required',
        
        ]);
        $groups= [];
        
        foreach($request->groups as $group_id){
        $group = Group::find($group_id);
        $group->exams=Exam::where('group_id',$group_id)->get();
        // $ex->questions=Question::where('exam_id',$exam_id)->with('answers')->get();
        $groups[]= $group;
        
        }
        
        return response()->json([
        'status'=>200,
        'data'=>[
        'groups'=>$groups
        ]
        ],200);
        
        }
}
